'===========================================================================
'              OverLoader Support Library for QuickBASIC 4.5
'                        by Plasma / Jon Petrosky
'                            www.phatcode.net                   [06-12-2001]
'---------------------------------------------------------------------------
'                  OverLoader v1.01 by Zilym Limms/OTM
'===========================================================================

DEFINT A-Z
'$DYNAMIC

TYPE RegType
  ax AS INTEGER
  bx AS INTEGER
  cx AS INTEGER
  dx AS INTEGER
  bp AS INTEGER
  si AS INTEGER
  di AS INTEGER
  flags AS INTEGER
END TYPE

TYPE OverLoaderHeader
  Filename AS STRING * 12
  FileLoc AS LONG
  FileSize AS LONG
END TYPE

TYPE OverLoaderEnd
  ID AS STRING * 10
  Entries AS STRING * 1
  Location AS LONG
END TYPE

DECLARE FUNCTION OverLoader.ProgName$ ()
DECLARE FUNCTION OverLoader.FileSeek& (Filename$, FileHandle%)

' Here is an example of how to use OverLoader...
'
' First, create a small text file called TEST.TXT and save it. Now compile
' this program as TEST.EXE. Make sure these files are in the same directory
' as OL.EXE.
'
' Next, run OverLoader like so:
'
' OL TEST.EXE TEST.TXT
'
' Execute TEST.EXE and you should see your text file on the screen. No extra
' files or other crap to deal with!
'
'
' Here's how it works...
'
' First we get the filename of the currently running EXE. This won't work in
' the QB IDE because the function will return QB.EXE. So, you must always
' compile if you want to use OverLoader.
'
Filename$ = OverLoader.ProgName$
'
' Now we open the file in BINARY mode using a free file handle
FileHandle = FREEFILE
OPEN Filename$ FOR BINARY AS #FileHandle
'
' Next, we pass the OverLoaded filename (TEST.TXT, in this case) and the
' file handle to the OverLoader.FileSeek& function. The function returns
' either the OverLoaded file length, or an error code (if the number is
' negative).
'
FileLen& = OverLoader.FileSeek&("TEST.TXT", FileHandle)
IF FileLen& = -1 THEN
  PRINT "Couldn't find OverLoader ID header"
  END
ELSEIF FileLen& = -2 THEN
  PRINT "OverLoaded file request not found"
  END
END IF
'
' If there wasn't an error code, then the read/write location of the file is
' now set to the start of the OverLoaded file, and we have the length of the
' file stored in FileLen&. You can do just about anything you want with the
' file at this point. Just remember that EOF, LOF, and LOC are not accurate!
'
' We're going to display the text file as an example.
'
CLS
Byte$ = SPACE$(1)
FOR x& = 1 TO FileLen&
  GET #1, , Byte$
  IF Byte$ >= CHR$(32) THEN
    PRINT Byte$;
  ELSEIF Byte$ = CHR$(13) THEN
    PRINT
  END IF
NEXT
'
' Don't forget to close the file when you're done!
'
CLOSE #1
END

FUNCTION OverLoader.FileSeek& (Filename$, FileHandle)

  '=========================================================================
  ' Sets the read/write position of the specified file handle to the
  ' start of the OverLoaded file contained in Filename$. The function
  ' returns the length of the OverLoaded file.
  '-------------------------------------------------------------------------
  ' Filename$  = Name of the OverLoaded file which is tacked onto the end
  '              of a EXE file.
  ' FileHandle = The file handle that is assigned to the EXE file. The
  '              EXE file must already be open in BINARY mode. Use
  '              OverLoader.ProgName$ to find the filename of the
  '              currently running EXE.
  '-------------------------------------------------------------------------
  '    Returns:  The length of the OverLoaded file in bytes. Maximum file
  '              size is 2 GB.
  '
  ' Or, if an error occurs, one of the following error codes is returned:
  '
  '         -1 = Couldn't find OverLoader ID header
  '         -2 = OverLoaded file request not found
  '=========================================================================

  DIM Header AS OverLoaderHeader
  DIM EndHeader AS OverLoaderEnd

  OverLoad$ = Filename$ + STRING$(12 - LEN(Filename$), 0)

  SEEK #FileHandle, LOF(FileHandle) - 14
  GET #FileHandle, , EndHeader

  IF EndHeader.ID <> "OverLoader" THEN
    OverLoader.FileSeek& = -1
    EXIT FUNCTION
  END IF

  SEEK #FileHandle, EndHeader.Location

  FOR Search = 1 TO ASC(EndHeader.Entries)
    GET #FileHandle, , Header
    IF Header.Filename = OverLoad$ THEN EXIT FOR
  NEXT

  IF Search = ASC(EndHeader.Entries) + 1 THEN
    OverLoader.FileSeek& = -2
    EXIT FUNCTION
  END IF

  SEEK #FileHandle, Header.FileLoc
  OverLoader.FileSeek& = Header.FileSize

END FUNCTION

FUNCTION OverLoader.ProgName$

  '=========================================================================
  ' Returns the full filename (including drive and path) of the currently
  ' running EXE program. If you are in the QB IDE, this will always
  ' return QB.EXE, not the name of your QB source code.
  '-------------------------------------------------------------------------
  ' Returns: String of variable length containing EXE filename of the
  '          currently running program.
  '=========================================================================

  DIM Regs AS RegType

  Regs.ax = &H6200
  CALL INTERRUPT(&H21, Regs, Regs)

  DEF SEG = Regs.bx
  DEF SEG = PEEK(44) + 256& * PEEK(45)

  Offset = 0
  DO UNTIL PEEK(Offset) = 0 AND PEEK(Offset + 1) = 0
    Offset = Offset + 1
  LOOP

  Offset = Offset + 4
  DO UNTIL PEEK(Offset) = 0
    Filename$ = Filename$ + CHR$(PEEK(Offset))
    Offset = Offset + 1
  LOOP

  DEF SEG
  OverLoader.ProgName$ = Filename$

END FUNCTION

