'===========================================================================
' SetVideoSeg 1.0 by Plasma / Jon Petrosky  [07-14-2002]
' www.phatcode.net
'---------------------------------------------------------------------------
' Changes QB's active video segment for SCREEN 13.
'---------------------------------------------------------------------------
' * Works for all graphics functions (does not work with PRINT)
' * Compatible with SuperPut (any version)
' * Compatible with:      QBASIC 1.x
'                     QuickBASIC 4.x (IDE & compiled)
'                         QB PDS 7.x (IDE & compiled)
'                          VBDOS 1.0 (IDE & compiled)
'
'   Note: If you compile your program, it must be compiled as a
'         stand-alone EXE!
'===========================================================================

DEFINT A-Z
DECLARE SUB SetVideoSeg (Segment)

' Here's a useless example that just shifts the segment 16 bytes. Not very
' useful, but you get the picture. ;) You can easily change the segment to
' the EMS pageframe or a buffer in conventional memory.

SCREEN 13
SetVideoSeg &HA000
PSET (0, 0), 15

SetVideoSeg &HA001
PSET (0, 0), 15

k$ = INPUT$(1)
END


SUB SetVideoSeg (Segment) STATIC

  '=========================================================================
  ' SetVideoSeg 1.0 by Plasma / Jon Petrosky  [07-14-2002]
  '-------------------------------------------------------------------------
  ' Changes QB's active video segment for SCREEN 13.
  '-------------------------------------------------------------------------
  ' Parameters: Segment = active video segment to use
  '                       (&HA000 for the screen)
  '-------------------------------------------------------------------------
  ' * Works for all graphics functions (does not work with PRINT)
  ' * Compatible with SuperPut (any version)
  ' * Compatible with:      QBASIC 1.x
  '                     QuickBASIC 4.x (IDE & compiled)
  '                         QB PDS 7.x (IDE & compiled)
  '                          VBDOS 1.0 (IDE & compiled)
  '
  '   Note: If you compile your program, it must be compiled as a
  '         stand-alone EXE!
  '=========================================================================

  DEF SEG

  IF VideoAddrOff& = 0 THEN   ' First time the sub is called

    ' We need to find the location of b$AddrC, which holds the graphics
    ' offset (b$OffC) and segment (b$SegC). Since b$AddrC is in the default
    ' segment, we can find it by setting it to a certain value, and then
    ' searching for that value.

    SCREEN 13                 ' Set b$SegC to A000 (00A0 in memory)
    PSET (160, 100), 0        ' Set b$OffC to 7DA0 (not needed in the IDE)

    FOR Offset& = 0 TO 32764                 ' Search for b$AddrC, which is
      IF PEEK(Offset&) = &HA0 THEN           ' in the default segment and
        IF PEEK(Offset& + 1) = &H7D THEN     ' should have a value of
          IF PEEK(Offset& + 2) = &H0 THEN    ' A0 7D 00 A0.
            IF PEEK(Offset& + 3) = &HA0 THEN
              VideoAddrOff& = Offset& + 2    ' If we found it, record the
              EXIT FOR                       ' offset of b$SegC and quit
            END IF                           ' looking. (Oddly, changing
          END IF                             ' the b$OffC doesn't seem to
        END IF                               ' do anything, so this is why
      END IF                                 ' this sub only changes b$SegC)
    NEXT

  END IF

  ' Change b$SegC to the specified Segment

  POKE VideoAddrOff&, Segment AND &HFF
  POKE VideoAddrOff& + 1, (Segment AND &HFF00&) \ &H100

END SUB

