'===========================================================================
' SetVideoSeg 1.1 by Plasma / Jon Petrosky  [02-09-2004]
' www.phatcode.net
'---------------------------------------------------------------------------
' Changes QB's active video segment for SCREEN 13.
'---------------------------------------------------------------------------
' * Works for all graphics functions (does not work with PRINT)
' * Compatible with SuperPut (any version)
' * Compatible with:      QBASIC 1.x
'                     QuickBASIC 4.x (IDE & compiled)
'                         QB PDS 7.x (IDE & compiled)
'                          VBDOS 1.0 (IDE & compiled)
'
'   Note: If you compile your program, it must be compiled as a
'         stand-alone EXE!
'===========================================================================

DEFINT A-Z
DECLARE SUB SetVideoSeg (Segment)

' Here's a useless example that just shifts the segment 16 bytes. Not very
' useful, but you get the picture. ;) You can easily change the segment to
' the EMS pageframe or a buffer in conventional memory.

SCREEN 13
SetVideoSeg &HA000
PSET (0, 0), 15

SetVideoSeg &HA001
PSET (0, 0), 15

k$ = INPUT$(1)
END


SUB SetVideoSeg (Segment) STATIC

  '=========================================================================
  ' SetVideoSeg 1.1 by Plasma / Jon Petrosky  [02-09-2004]
  '-------------------------------------------------------------------------
  ' Changes QB's active video segment for SCREEN 13.
  '-------------------------------------------------------------------------
  ' Parameters: Segment = active video segment to use
  '                       (&HA000 for the screen)
  '-------------------------------------------------------------------------
  ' * Works for all graphics functions (does not work with PRINT)
  ' * Compatible with SuperPut (any version)
  ' * Compatible with:      QBASIC 1.x
  '                     QuickBASIC 4.x (IDE & compiled)
  '                         QB PDS 7.x (IDE & compiled)
  '                          VBDOS 1.0 (IDE & compiled)
  '
  '   Note: If you compile your program, it must be compiled as a
  '         stand-alone EXE!
  '=========================================================================

  DEF SEG

  ' If SetVideoSeg was previously called, we can just
  ' set the new segment and bail.

  IF VideoSegOff <> 0 THEN
    POKE VideoSegOff, Segment AND &HFF
    POKE VideoSegOff + 1, (Segment AND &HFF00&) \ &H100
    EXIT SUB
  END IF


  ' Otherwise we have to search for b$AddrC, which holds the
  ' graphics offset (b$OffC) and segment (b$SegC). Since b$AddrC
  ' is in the default segment, we can find it by setting it to a
  ' certain value, and then searching for that value.

  SCREEN 13             ' Set b$SegC to A000 (00A0 in memory)
  PSET (160, 100), 0    ' Set b$OffC to 7DA0 (not needed in the IDE)

  ' Search for b$AddrC, which is in the default segment and
  ' should have a value of A0 7D 00 A0.
  FOR i = 0 TO &H7FFC
    IF PEEK(i) = &HA0 AND PEEK(i + 1) = &H7D THEN
    IF PEEK(i + 2) = &H0 AND PEEK(i + 3) = &HA0 THEN
      ' Found it, so set b$SegC to the specified segment and exit
      VideoSegOff = i + 2
      POKE VideoSegOff, Segment AND &HFF
      POKE VideoSegOff + 1, (Segment AND &HFF00&) \ &H100
      EXIT SUB
    END IF
    END IF
  NEXT

  SCREEN 0
  WIDTH 80, 25
  PRINT "SetVideoSeg Error: Cannot find video segment offset."
  PRINT "Check to make sure you are using a compatible version of QB."
  END

END SUB

