'===========================================================================
' SetVideoSeg 1.2 by Plasma / Jon Petrosky  [04-22-2004]
' www.phatcode.net
'---------------------------------------------------------------------------
' Changes QB's active video segment for SCREEN 13.
'---------------------------------------------------------------------------
' * Works for all graphics functions (does not work with PRINT)
' * Compatible with SuperPut (any version)
' * Compatible with:      QBASIC 1.x
'                     QuickBASIC 4.x (IDE & compiled)
'                         QB PDS 7.1 (IDE & compiled)
'                          VBDOS 1.0 (IDE & compiled)
'
'   Note: If you compile your program, it must be compiled as a
'         stand-alone EXE!
'===========================================================================

DEFINT A-Z
DECLARE FUNCTION SetVideoSeg (Segment)

' Here's a useless example that just shifts the segment 16 bytes. Not very
' useful, but you get the picture. ;) You can easily change the segment to
' the EMS pageframe or a buffer in conventional memory.

SCREEN 13
rc = SetVideoSeg(&HA000)
PSET (0, 0), 15

rc = SetVideoSeg(&HA001)
PSET (0, 0), 15

k$ = INPUT$(1)
END


FUNCTION SetVideoSeg (Segment)

  '=========================================================================
  ' SetVideoSeg 1.2 by Plasma / Jon Petrosky  [04-22-2004]
  '-------------------------------------------------------------------------
  ' Changes QB's active video segment for SCREEN 13.
  '-------------------------------------------------------------------------
  ' Parameters: Segment = active video segment to use
  '                       (&HA000 for the screen)
  '
  ' Returns:             0 = Error (could not find b$SegC)
  '          anything else = Offset of b$SegC from the default segment
  '                          (used by SuperPut)
  '-------------------------------------------------------------------------
  ' * Works for all graphics functions (does not work with PRINT)
  ' * Compatible with SuperPut (any version)
  ' * Compatible with:      QBASIC 1.x
  '                     QuickBASIC 4.x (IDE & compiled)
  '                         QB PDS 7.x (IDE & compiled)
  '                          VBDOS 1.0 (IDE & compiled)
  '
  '   Note: If you compile your program, it must be compiled as a
  '         stand-alone EXE!
  '=========================================================================

  STATIC VideoSegOff
  DEF SEG

  ' If SetVideoSeg was previously called, we can just
  ' set the new segment and bail.
  IF VideoSegOff <> 0 THEN
    POKE VideoSegOff, Segment AND &HFF
    POKE VideoSegOff + 1, (Segment AND &HFF00&) \ &H100
    SetVideoSeg = VideoSegOff
    EXIT FUNCTION
  END IF


  ' Otherwise we have to search for b$AddrC, which holds the
  ' graphics offset (b$OffC) and segment (b$SegC). Since b$AddrC
  ' is in the default segment, we can find it by setting it to a
  ' certain value, and then searching for that value.

  SCREEN 13             ' Set b$SegC to A000 (00A0 in memory)
  PSET (160, 100), 0    ' Set b$OffC to 7DA0

  ' Search for b$AddrC, which is in the default segment and
  ' should have a value of A0 7D 00 A0.
  FOR i = 0 TO &H7FFC
    IF PEEK(i) = &HA0 AND PEEK(i + 1) = &H7D THEN
    IF PEEK(i + 2) = &H0 AND PEEK(i + 3) = &HA0 THEN
      ' Found it, so set b$SegC to the specified segment and exit
      VideoSegOff = i + 2
      POKE VideoSegOff, Segment AND &HFF
      POKE VideoSegOff + 1, (Segment AND &HFF00&) \ &H100
      SetVideoSeg = VideoSegOff
      EXIT FUNCTION
    END IF
    END IF
  NEXT

  ' Return an error (couldn't find b$SecC)
  SetVideoSeg = 0

END FUNCTION

