'===========================================================================
' Simple SetVideoSeg 1.2 example by Plasma / Jon Petrosky  [11-28-2003]
'===========================================================================

DEFINT A-Z
'$DYNAMIC

DECLARE FUNCTION SetVideoSeg (Segment)

DIM Buffer(32006)  'an extra 16 bytes are needed so that the image
Buffer(6) = 2560   'can be aligned evenly on a segment (the 4 bytes for
Buffer(7) = 200    'the x and y sprite size normally throw this off, so we
BufferSeg = VARSEG(Buffer(0)) + 1  'have to shift everything over 12 bytes

SCREEN 13
rc = SetVideoSeg(BufferSeg)   'Draw all the setup stuff on the buffer

DIM SpriteImage(129)
DIM SpriteMask(129)
DIM SaveBackground(129)

'Create the sprite
LINE (0, 0)-(15, 15), 255, BF
CIRCLE (8, 8), 7, 4, , , .83
PAINT (8, 8), 4
CIRCLE (10, 7), 2, 12, , , .83
PAINT (10, 7), 12
GET (0, 0)-(15, 15), SpriteImage(0)

'Create the mask from the sprite
FOR y = 0 TO 15
  FOR x = 0 TO 15
    IF POINT(x, y) = 255 THEN
      PSET (x + 16, y), 0
    ELSE
      PSET (x + 16, y), 255
    END IF
  NEXT
NEXT
GET (16, 0)-(31, 15), SpriteMask(0)

CLS

'Draw some background shiznit on the buffer
FOR x = 0 TO 319
  LINE (x, 0)-(x, 199), x AND 255
NEXT

DO
  FOR x = 0 TO 304

    IF INKEY$ <> "" THEN EXIT DO

    'restore old background
    IF x > 0 THEN PUT (x - 1, 92), SaveBackground(0), PSET

    'save new background
    GET (x, 92)-(x + 15, 107), SaveBackground(0)

    'Put sprite while preserving background
    PUT (x, 92), SpriteMask(0), OR
    PUT (x, 92), SpriteImage(0), AND

    'Copy the buffer to video memory
    rc = SetVideoSeg(&HA000)
    WAIT &H3DA, 8  'Wait for vsync (optional)
    PUT (0, 0), Buffer(6), PSET
    rc = SetVideoSeg(BufferSeg)

  NEXT

  PUT (x - 1, 92), SaveBackground(0), PSET

LOOP


FUNCTION SetVideoSeg (Segment)

  '=========================================================================
  ' SetVideoSeg 1.2 by Plasma / Jon Petrosky  [04-22-2004]
  '-------------------------------------------------------------------------
  ' Changes QB's active video segment for SCREEN 13.
  '-------------------------------------------------------------------------
  ' Parameters: Segment = active video segment to use
  '                       (&HA000 for the screen)
  '
  ' Returns:             0 = Error (could not find b$SegC)
  '          anything else = Offset of b$SegC from the default segment
  '                          (used by SuperPut)
  '-------------------------------------------------------------------------
  ' * Works for all graphics functions (does not work with PRINT)
  ' * Compatible with SuperPut (any version)
  ' * Compatible with:      QBASIC 1.x
  '                     QuickBASIC 4.x (IDE & compiled)
  '                         QB PDS 7.x (IDE & compiled)
  '                          VBDOS 1.0 (IDE & compiled)
  '
  '   Note: If you compile your program, it must be compiled as a
  '         stand-alone EXE!
  '=========================================================================

  STATIC VideoSegOff
  DEF SEG

  ' If SetVideoSeg was previously called, we can just
  ' set the new segment and bail.
  IF VideoSegOff <> 0 THEN
    POKE VideoSegOff, Segment AND &HFF
    POKE VideoSegOff + 1, (Segment AND &HFF00&) \ &H100
    SetVideoSeg = VideoSegOff
    EXIT FUNCTION
  END IF


  ' Otherwise we have to search for b$AddrC, which holds the
  ' graphics offset (b$OffC) and segment (b$SegC). Since b$AddrC
  ' is in the default segment, we can find it by setting it to a
  ' certain value, and then searching for that value.

  SCREEN 13             ' Set b$SegC to A000 (00A0 in memory)
  PSET (160, 100), 0    ' Set b$OffC to 7DA0

  ' Search for b$AddrC, which is in the default segment and
  ' should have a value of A0 7D 00 A0.
  FOR i = 0 TO &H7FFC
    IF PEEK(i) = &HA0 AND PEEK(i + 1) = &H7D THEN
    IF PEEK(i + 2) = &H0 AND PEEK(i + 3) = &HA0 THEN
      ' Found it, so set b$SegC to the specified segment and exit
      VideoSegOff = i + 2
      POKE VideoSegOff, Segment AND &HFF
      POKE VideoSegOff + 1, (Segment AND &HFF00&) \ &H100
      SetVideoSeg = VideoSegOff
      EXIT FUNCTION
    END IF
    END IF
  NEXT

  ' Return an error (couldn't find b$SecC)
  SetVideoSeg = 0

END FUNCTION

