'===========================================================================
' SuperPut 1.2 by Plasma / Jon Petrosky  [04-22-2004]
' Props to Rel for the original idea and the updated RelSpriteFlip
' www.phatcode.net
'---------------------------------------------------------------------------
' Replaces QB's graphics PUT with Rel's optimized routine that supports
' user-defined clipping, transparency, and flipping. Clipping range is set
' with QB's VIEW statement.
'===========================================================================

DEFINT A-Z
DECLARE FUNCTION SuperPut (Install)
DECLARE FUNCTION SetVideoSeg (Segment)

' Example...

SCREEN 13          ' (not really needed because SuperPut sets screen 13)
rc = SuperPut(1)   ' Install SuperPut

IF rc >= 0 THEN    ' Error checking
  SCREEN 0
  WIDTH 80, 25
  SELECT CASE rc
    CASE 0: PRINT "SuperPut error: Could not find b$SegC"
    CASE 1: PRINT "SuperPut error: Could not find B$PUT"
    CASE 2: PRINT "SuperPut error: Could not find B$VIEW"
  END SELECT
  k$ = INPUT$(1)
  END
END IF

' Simple 32x32 sprite for testing
DIM Sprite(513)
CIRCLE (15, 15), 14, 4
PAINT (15, 15), 4
CIRCLE (10, 10), 4, 12
PAINT (10, 10), 12
GET (0, 0)-(31, 31), Sprite(0)
CLS

' Slap a background up
FOR x = 0 TO 319
  LINE (x, 0)-(x, 199), x MOD 255
NEXT

' Set a custom clipping range
VIEW (0, 31)-(319, 167)

' Draw some sprites
FOR y = 12 TO 156 STEP 48
  PUT (25, y), Sprite(0), PSET             ' (no flipping, no transparency)
  PUT (85, y), Sprite(0)  '(default is XOR)  (no flipping)
  PUT (145, y), Sprite(0), PRESET          ' (flipped horizontally)
  PUT (205, y), Sprite(0), OR              ' (flipped vertically)
  PUT (265, y), Sprite(0), AND             ' (flipped both ways)
NEXT

k$ = INPUT$(1)
rc = SuperPut(0)   ' Remove SuperPut
END


FUNCTION SetVideoSeg (Segment)

  '=========================================================================
  ' SetVideoSeg 1.2 by Plasma / Jon Petrosky  [04-22-2004]
  '-------------------------------------------------------------------------
  ' Changes QB's active video segment for SCREEN 13.
  '-------------------------------------------------------------------------
  ' Parameters: Segment = active video segment to use
  '                       (&HA000 for the screen)
  '
  ' Returns:             0 = Error (could not find b$SegC)
  '          anything else = Offset of b$SegC from the default segment
  '                          (used by SuperPut)
  '-------------------------------------------------------------------------
  ' * Works for all graphics functions (does not work with PRINT)
  ' * Compatible with SuperPut (any version)
  ' * Compatible with:      QBASIC 1.x
  '                     QuickBASIC 4.x (IDE & compiled)
  '                         QB PDS 7.x (IDE & compiled)
  '                          VBDOS 1.0 (IDE & compiled)
  '
  '   Note: If you compile your program, it must be compiled as a
  '         stand-alone EXE!
  '=========================================================================

  STATIC VideoSegOff
  DEF SEG

  ' If SetVideoSeg was previously called, we can just
  ' set the new segment and bail.
  IF VideoSegOff <> 0 THEN
    POKE VideoSegOff, Segment AND &HFF
    POKE VideoSegOff + 1, (Segment AND &HFF00&) \ &H100
    SetVideoSeg = VideoSegOff
    EXIT FUNCTION
  END IF


  ' Otherwise we have to search for b$AddrC, which holds the
  ' graphics offset (b$OffC) and segment (b$SegC). Since b$AddrC
  ' is in the default segment, we can find it by setting it to a
  ' certain value, and then searching for that value.

  SCREEN 13             ' Set b$SegC to A000 (00A0 in memory)
  PSET (160, 100), 0    ' Set b$OffC to 7DA0

  ' Search for b$AddrC, which is in the default segment and
  ' should have a value of A0 7D 00 A0.
  FOR i = 0 TO &H7FFC
    IF PEEK(i) = &HA0 AND PEEK(i + 1) = &H7D THEN
    IF PEEK(i + 2) = &H0 AND PEEK(i + 3) = &HA0 THEN
      ' Found it, so set b$SegC to the specified segment and exit
      VideoSegOff = i + 2
      POKE VideoSegOff, Segment AND &HFF
      POKE VideoSegOff + 1, (Segment AND &HFF00&) \ &H100
      SetVideoSeg = VideoSegOff
      EXIT FUNCTION
    END IF
    END IF
  NEXT

  ' Return an error (couldn't find b$SecC)
  SetVideoSeg = 0

END FUNCTION

FUNCTION SuperPut (Install)

  '=========================================================================
  ' SuperPut 1.2 by Plasma / Jon Petrosky  [04-22-2004]
  ' Props to Rel for the original idea and the updated RelSpriteFlip
  '-------------------------------------------------------------------------
  ' Replaces QB's graphics PUT with Rel's optimized routine that supports
  ' user-defined clipping, transparency, and flipping. Clipping range is set
  ' with QB's VIEW statement.
  '-------------------------------------------------------------------------
  ' Clipping: Sprites will be clipped if they are partially off-screen,
  '           rather than returning "Illegal Function Call". This also means
  '           you can pass negative coordinates.
  '
  '           Sprites will also be clipped if they are partially out of the
  '           user-defined clipping region set with VIEW.
  '
  ' Transparency: Color 0 is always the transparent color, except when the
  '               PSET actionverb is passed (transparency is then ignored).
  '
  ' New PUT actionverbs:     XOR - not flipped (default)
  '                         PSET - not flipped & no transparency
  '                       PRESET - flipped horizontally
  '                           OR - flipped vertically
  '                          AND - flipped horizontally & vertically
  '
  ' New VIEW behavior: When SuperPut is installed, VIEW will set the user-
  '                    defined clipping boundary. However, *only* this form
  '                    of the statement is supported:
  '
  '                    VIEW (x1, y1)-(x2, y2)
  '
  '                    The maximum range is (0, 0)-(319, 199). If you do not
  '                    specify a range, the clipping range will NOT be set
  '                    to the entire screen. The SCREEN, COLOR, and BORDER
  '                    options may be passed, but they will be ignored.
  '
  '                    When SuperPut is installed, VIEW will only change
  '                    the clipping area for the PUT statement. If you need
  '                    to change the clipping area for other graphics
  '                    statements, use VIEW before installing SuperPut or
  '                    after removing it.
  '-------------------------------------------------------------------------
  ' Parameters: Install = Install SuperPut (non-zero) or
  '                       Remove SuperPut (0)
  '
  ' Returns:            -3 = Remove Error (not installed)
  '                     -2 = Install Error (already installed)
  '                     -1 = Success
  '                      0 = Fatal Error (could not find b$SegC)
  '                      1 = Fatal Error (could not find B$PUT)
  '                      2 = Fatal Error (could not find B$VIEW)
  '-------------------------------------------------------------------------
  ' * Works with SCREEN 13 only
  ' * Requires SetVideoSeg 1.2
  ' * Compatible with:      QBASIC 1.x
  '                     QuickBASIC 4.x (IDE & compiled)
  '                         QB PDS 7.x (IDE & compiled)
  '                          VBDOS 1.0 (IDE & compiled)
  '
  '   Note: If you compile your program, it must be compiled as a
  '         stand-alone EXE!
  '=========================================================================

  STATIC VideoSegOff
  STATIC PutSeg&, PutOff, ViewSeg&, ViewOff
  STATIC NewPut&(), OldPut&(), OldView&()

  IF Install <> 0 THEN  ' Install SuperPut

    ' Easy way to get the default segment
    DefSeg& = VARSEG(DefSeg$)

    IF VideoSegOff = 0 THEN
      ' Get the location of b$SegC from SetVideoSeg
      VideoSegOff = SetVideoSeg(&HA000)
      IF VideoSegOff = 0 THEN
        SuperPut = 0
        EXIT FUNCTION
      END IF
    END IF

    IF PutSeg& = 0 THEN
      ' Find QB's B$GPUT routine by searching for some known opcodes
      ' (backwards from the default segment)
      PutSeg& = DefSeg& - &H400
      DO WHILE PutSeg& > 0
        DEF SEG = PutSeg&
        FOR i = 0 TO &H3FF4
          IF PEEK(i) = &HC4 AND PEEK(i + 1) = &H5E AND PEEK(i + 2) = &HA THEN
          IF PEEK(i + 3) = &H8C AND PEEK(i + 4) = &HC1 AND PEEK(i + 5) = &H41 THEN
          IF PEEK(i + 6) = &HE2 AND PEEK(i + 7) = &H5 AND PEEK(i + 8) = &H8B THEN
          IF PEEK(i + 9) = &H5E AND PEEK(i + 10) = &H8 AND PEEK(i + 11) = &HC4 THEN
          IF PEEK(i + 12) = &H1F THEN
            PutOff = i                'Routine entry point is 16 bytes before
            PutSeg& = PutSeg& - 1     'the anchor, so just decrease the segment
            EXIT DO                   'and we have the real entry point.
          END IF
          END IF
          END IF
          END IF
          END IF
        NEXT
        PutSeg& = PutSeg& - &H3FF
      LOOP
      IF i = &H3FF5 THEN
        PutSeg& = 0
        SuperPut = 1
        EXIT FUNCTION
      END IF
    END IF

    IF ViewSeg& = 0 THEN
      ' Find QB's B$VIEW routine by searching for some known opcodes
      ' (backwards from the default segment)
      ViewSeg& = DefSeg& - &H400
      DO WHILE ViewSeg& > 0
        DEF SEG = ViewSeg&
        FOR i = 6 TO &H3FF2
          IF PEEK(i) = &H8B AND PEEK(i + 1) = &H5E AND PEEK(i + 2) = &H12 THEN
          IF PEEK(i + 3) = &H8B AND PEEK(i + 4) = &H56 AND PEEK(i + 5) = &H10 THEN
          IF PEEK(i + 9) = &H8B AND PEEK(i + 10) = &H5E AND PEEK(i + 11) = &HE THEN
          IF PEEK(i + 12) = &H8B AND PEEK(i + 13) = &H56 AND PEEK(i + 14) = &HC THEN
            ViewOff = i - 6     ' Routine entry point is 6 bytes before anchor
            EXIT DO
          END IF
          END IF
          END IF
          END IF
        NEXT
        ViewSeg& = ViewSeg& - &H3FF
      LOOP
      IF i = &H3FF3 THEN
        ViewSeg& = 0
        SuperPut = 2
        EXIT FUNCTION
      END IF
    END IF

    ' Save the part of the old B$PUT routine that gets overwritten
    DEF SEG = PutSeg&
    IF PEEK(PutOff + &H1D) <> &H26 THEN
      ' SuperPut is already installed
      SuperPut = -2
      EXIT FUNCTION
    ELSE
      REDIM OldPut&(8)
      FOR i = 0 TO 35
        DEF SEG = PutSeg&
        Opcode = PEEK(PutOff + &H1D + i)
        DEF SEG = VARSEG(OldPut&(0))
        POKE i, Opcode
      NEXT
    END IF

    ' Save the part of the old B$VIEW routine that gets overwritten
    REDIM OldView&(7)
    FOR i = 0 TO 30
      DEF SEG = ViewSeg&
      Opcode = PEEK(ViewOff + &H3 + i)
      DEF SEG = VARSEG(OldView&(0))
      POKE i, Opcode
    NEXT

    ' New modified version of RelSpriteFlip that supports custom clipping
    REDIM NewPut&(159)
    NewPut&(0)   = &HEBC11C8B: NewPut&(1)   = &H1E892E03: NewPut&(2)   = &H892E0266
    NewPut&(3)   = &H8B026C1E: NewPut&(4)   = &H892E0254: NewPut&(5)   = &H2E026816
    NewPut&(6)   = &H026E1689: NewPut&(7)   = &H6406C72E: NewPut&(8)   = &H2E000002
    NewPut&(9)   = &H026A06C7: NewPut&(10)  = &HC72E0000: NewPut&(11)  = &H00027006
    NewPut&(12)  = &H06C72E00: NewPut&(13)  = &H00000272: NewPut&(14)  = &H7606C72E
    NewPut&(15)  = &H2E000002: NewPut&(16)  = &H027406C7: NewPut&(17)  = &HC6830000
    NewPut&(18)  = &H0A468B04: NewPut&(19)  = &H7E063B2E: NewPut&(20)  = &H958F0F02
    NewPut&(21)  = &H063B2E00: NewPut&(22)  = &H8C0F027A: NewPut&(23)  = &H4E8B00BA
    NewPut&(24)  = &H0E3B2E08: NewPut&(25)  = &H8F0F027C: NewPut&(26)  = &H3B2E0080
    NewPut&(27)  = &H0F02780E: NewPut&(28)  = &H0300C18C: NewPut&(29)  = &H1E3B2ED8
    NewPut&(30)  = &H8F0F027E: NewPut&(31)  = &HD82B00D6: NewPut&(32)  = &H3B2ED103
    NewPut&(33)  = &H0F027C16: NewPut&(34)  = &H2B00E48F: NewPut&(35)  = &H1E892ED1
    NewPut&(36)  = &HE9860266: NewPut&(37)  = &H8B0140BB: NewPut&(38)  = &H1E2B2EF9
    NewPut&(39)  = &HEFC10266: NewPut&(40)  = &H2EF90302: NewPut&(41)  = &H026A1E89
    NewPut&(42)  = &H7E83F803: NewPut&(43)  = &H840F0206: NewPut&(44)  = &H7E8300DC
    NewPut&(45)  = &H840F0006: NewPut&(46)  = &H7E830104: NewPut&(47)  = &H840F0106
    NewPut&(48)  = &H7E83014B: NewPut&(49)  = &H2A740306: NewPut&(50)  = &H661E8B2E
    NewPut&(51)  = &H8ACB8B02: NewPut&(52)  = &HC00A4604: NewPut&(53)  = &H88260374
    NewPut&(54)  = &H75494705: NewPut&(55)  = &H3E032EF2: NewPut&(56)  = &H032E026A
    NewPut&(57)  = &H4A026436: NewPut&(58)  = &H071FE375: NewPut&(59)  = &HCA5D5E5F
    NewPut&(60)  = &H2EFC0008: NewPut&(61)  = &H02661E8B: NewPut&(62)  = &HE8C1C38B
    NewPut&(63)  = &H03E38302: NewPut&(64)  = &H66F3C88B: NewPut&(65)  = &HF3CB8BA5
    NewPut&(66)  = &H3E032EA4: NewPut&(67)  = &H032E026A: NewPut&(68)  = &H4A026436
    NewPut&(69)  = &HD2EBEA75: NewPut&(70)  = &H032ED8F7: NewPut&(71)  = &H2B027A06
    NewPut&(72)  = &H03C77ED8: NewPut&(73)  = &H64A32EF0: NewPut&(74)  = &H74A32E02
    NewPut&(75)  = &H7AA12E02: NewPut&(76)  = &HFF2AE902: NewPut&(77)  = &H032ED9F7
    NewPut&(78)  = &H2B02780E: NewPut&(79)  = &H2EAB7ED1: NewPut&(80)  = &H02700E89
    NewPut&(81)  = &H6636032E: NewPut&(82)  = &HF8754902: NewPut&(83)  = &H780E8B2E
    NewPut&(84)  = &HFF1FE902: NewPut&(85)  = &H7E1E2B2E: NewPut&(86)  = &H012E4B02
    NewPut&(87)  = &H2E02641E: NewPut&(88)  = &H02721E89: NewPut&(89)  = &H7E1E8B2E
    NewPut&(90)  = &HD82B4302: NewPut&(91)  = &H03FF11E9: NewPut&(92)  = &H0E2B2ECA
    NewPut&(93)  = &H2B49027C: NewPut&(94)  = &H0E8B2ED1: NewPut&(95)  = &H892E026E
    NewPut&(96)  = &H2E02760E: NewPut&(97)  = &H02761629: NewPut&(98)  = &HE9084E8B
    NewPut&(99)  = &H032EFEFF: NewPut&(100) = &H2E027236: NewPut&(101) = &H02660E8B
    NewPut&(102) = &H2E4BD98B: NewPut&(103) = &H02741E2B: NewPut&(104) = &HC00A008A
    NewPut&(105) = &H88260374: NewPut&(106) = &H494B4705: NewPut&(107) = &H032EF275
    NewPut&(108) = &H2E026A3E: NewPut&(109) = &H026C3603: NewPut&(110) = &HE9D8754A
    NewPut&(111) = &H40B9FF2C: NewPut&(112) = &H4BDA8B01: NewPut&(113) = &H03CBAF0F
    NewPut&(114) = &H0E8B2EF9: NewPut&(115) = &H8B2E026C: NewPut&(116) = &H0F02701E
    NewPut&(117) = &HF12BCBAF: NewPut&(118) = &H026CA12E: NewPut&(119) = &H761E8B2E
    NewPut&(120) = &HC3AF0F02: NewPut&(121) = &H8B2EF003: NewPut&(122) = &H8A02660E
    NewPut&(123) = &HC00A4604: NewPut&(124) = &H88260374: NewPut&(125) = &H75494705
    NewPut&(126) = &H3E2B2EF2: NewPut&(127) = &HEF810266: NewPut&(128) = &H032E0140
    NewPut&(129) = &H4A026436: NewPut&(130) = &HDDE9DC75: NewPut&(131) = &H0E8B2EFE
    NewPut&(132) = &HDA8B026C: NewPut&(133) = &H03CBAF0F: NewPut&(134) = &H8B2E4EF1
    NewPut&(135) = &H2E026C0E: NewPut&(136) = &H02701E8B: NewPut&(137) = &H2BCBAF0F
    NewPut&(138) = &H6CA12EF1: NewPut&(139) = &H1E8B2E02: NewPut&(140) = &HAF0F0276
    NewPut&(141) = &H2EF003C3: NewPut&(142) = &H0274362B: NewPut&(143) = &H660E8B2E
    NewPut&(144) = &H362B2E02: NewPut&(145) = &H048A0274: NewPut&(146) = &H74C00A4E
    NewPut&(147) = &H05882603: NewPut&(148) = &HF2754947: NewPut&(149) = &H6A3E032E
    NewPut&(150) = &H362B2E02: NewPut&(151) = &H754A0272: NewPut&(152) = &HFE86E9DB
    NewPut&(159) = &H013F00C7

    ' Patch B$GPUT
    DEF SEG = PutSeg&
    POKE PutOff + &H1D, &H1E                 'push  ds
    POKE PutOff + &H1E, &HA1                 'mov   ax,B$GYPOS
    POKE PutOff + &H1F, PEEK(PutOff + &H42)
    POKE PutOff + &H20, PEEK(PutOff + &H43)
    POKE PutOff + &H21, &H89                 'mov   [bp+08],ax
    POKE PutOff + &H22, &H46
    POKE PutOff + &H23, &H8
    POKE PutOff + &H24, &HA1                 'mov   ax,B$GXPOS
    POKE PutOff + &H25, PEEK(PutOff + &H38)
    POKE PutOff + &H26, PEEK(PutOff + &H39)
    POKE PutOff + &H27, &H89                 'mov   [bp+0A],ax
    POKE PutOff + &H28, &H46
    POKE PutOff + &H29, &HA
    POKE PutOff + &H2A, &H89                 'mov   si,bx
    POKE PutOff + &H2B, &HDE
    POKE PutOff + &H2C, &H8C                 'mov   bx,es
    POKE PutOff + &H2D, &HC3
    POKE PutOff + &H2E, &H8E                 'mov   ds,bx
    POKE PutOff + &H2F, &HDB
    POKE PutOff + &H30, &HBB                 'mov   bx,DefSeg&
    POKE PutOff + &H31, DefSeg& AND &HFF
    POKE PutOff + &H32, (DefSeg& AND &HFF00&) \ &H100
    POKE PutOff + &H33, &H8E                 'mov   es,bx
    POKE PutOff + &H34, &HC3
    POKE PutOff + &H35, &H26                 'mov   bx,es:VideoSegOff
    POKE PutOff + &H36, &H8B
    POKE PutOff + &H37, &H1E
    POKE PutOff + &H38, VideoSegOff AND &HFF
    POKE PutOff + &H39, (VideoSegOff AND &HFF00&) \ &H100
    POKE PutOff + &H3A, &H8E                 'mov   es,bx
    POKE PutOff + &H3B, &HC3
    POKE PutOff + &H3C, &HEA                 'jmp   VARSEG(NewPut&(0)):0
    POKE PutOff + &H3D, 0
    POKE PutOff + &H3E, 0
    POKE PutOff + &H3F, VARSEG(NewPut&(0)) AND &HFF
    POKE PutOff + &H40, (VARSEG(NewPut&(0)) AND &HFF00&) \ &H100

    ' Patch B$VIEW
    DEF SEG = ViewSeg&
    POKE ViewOff + &H3, &H6                  'push es
    POKE ViewOff + &H4, &HBB                 'mov bx, VARSEG(NewPut&(0))
    POKE ViewOff + &H5, VARSEG(NewPut&(0)) AND &HFF
    POKE ViewOff + &H6, (VARSEG(NewPut&(0)) AND &HFF00&) \ &H100
    POKE ViewOff + &H7, &H8E                 'mov es, bx
    POKE ViewOff + &H8, &HC3
    POKE ViewOff + &H9, &HBB                 'mov bx, (offset of clipping bounds)
    POKE ViewOff + &HA, (UBOUND(NewPut&) * 4 - 4) AND &HFF
    POKE ViewOff + &HB, ((UBOUND(NewPut&) * 4 - 4) AND &HFF00&) \ &H100
    POKE ViewOff + &HC, &H66                 'mov eax,[bp+10h] (high word Y1, low word X1)
    POKE ViewOff + &HD, &H8B
    POKE ViewOff + &HE, &H46
    POKE ViewOff + &HF, &H10
    POKE ViewOff + &H10, &H26                'mov es:[bx], eax
    POKE ViewOff + &H11, &H66
    POKE ViewOff + &H12, &H89
    POKE ViewOff + &H13, &H7
    POKE ViewOff + &H14, &H66                'mov eax,[bp+0Ch] (high word Y2, low word X2)
    POKE ViewOff + &H15, &H8B
    POKE ViewOff + &H16, &H46
    POKE ViewOff + &H17, &HC
    POKE ViewOff + &H18, &H26                'mov es:[bx+04h], eax
    POKE ViewOff + &H19, &H66
    POKE ViewOff + &H1A, &H89
    POKE ViewOff + &H1B, &H47
    POKE ViewOff + &H1C, &H4
    POKE ViewOff + &H1D, &H7                 'pop es
    POKE ViewOff + &H1E, &H5D                'pop bp
    POKE ViewOff + &H1F, &HCA                'retf 000Eh
    POKE ViewOff + &H20, &HE
    POKE ViewOff + &H21, &H0

    ' Success
    SuperPut = -1
    EXIT FUNCTION

    ' PUT and VIEW must be used at least once
    ' so the compiler will include them.
    ' (This code never actually executes)
    DIM Nothing(0)
    PUT (0, 0), Nothing(0)
    VIEW

  ELSE  ' Remove SuperPut

    IF ViewSeg& = 0 THEN
      ' SuperPut was never installed
      SuperPut = -3
      EXIT FUNCTION
    END IF

    DEF SEG = ViewSeg&
    IF PEEK(ViewOff + &H3) <> &H6 THEN
      ' SuperPut was installed, but has already been removed
      SuperPut = -3
      EXIT FUNCTION
    END IF

    ' Restore old B$PUT routine
    FOR i = 0 TO 35
      DEF SEG = VARSEG(OldPut&(0))
      Opcode = PEEK(i)
      DEF SEG = PutSeg&
      POKE PutOff + &H1D + i, Opcode
    NEXT

    ' Restore old B$VIEW routine
    FOR i = 0 TO 30
      DEF SEG = VARSEG(OldView&(0))
      Opcode = PEEK(i)
      DEF SEG = ViewSeg&
      POKE ViewOff + &H3 + i, Opcode
    NEXT

    ' Success
    SuperPut = -1

  END IF

END FUNCTION

